*******************************************************************************
*                         680xx Grundprogramm textio                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                        Text- Ein- Ausgaberoutinen                           *
*******************************************************************************


print:                          * Werte in Folge an GDP bersenden
 bsr.s setprt                   * Alles erlaubt, auch Kurzvektoren
printlp:                        * Ohne Vorlschen
 move.b (a0)+,d0                * Wert holen
 beq.s printfi                  * 0 ist Endekennung
 bsr cmd                        * An GDP ausgeben / Auch Vektoren erlaubt
bra.s printlp
printfi:
rts

setprt:                         * Positionieren
 bsr moveto
 and.b #$f0, gdp+2*cpu.w        * Zeichen gerade aufrecht
 move.b d0,gdp+3*cpu.w          * Scalierung x,y
rts

centertxt:
 moveq #-1,d1                   * Gibt Text genau in der Mitte des Bildschirms
centtxt1:                       * aus / Fr berschriften bei Mensteuerung
 addq #1,d1                     * Anzahl+1
 tst.b 0(a0,d1.w)               * Anzahl der Zeichen feststellen
 bne.s centtxt1                 * Bis Null erreicht
 move d0,-(a7)
 lsr #4,d0                      * X-Vergrerung
 and #$f,d0
 bne.s centtxt2
 moveq #16,d0                   * Bei 0, Vergrerung mal 16
centtxt2:
 muls #-3,d0                    * Mal Zeichengre / 2
 muls d0,d1                     * Mal Anzahl der Zeichen
 move (a7)+,d0
 add #256,d1                    * Hlfte Bildschirmbreite
                                * Position berechnet, jetzt Text ausgeben

textaus:                        * Text ausgeben mit Vorlschen und Sonderzeichen
 movem.l d0-d2/a0,-(a7)
 bsr.s setprt                   * Positionieren und Schriftgre
 move d0,d2
 lsr #4,d2
 and #$f,d2
 bne.s texta0
 moveq #16,d2                   * Null ist Vergrerung 16
texta0:
 mulu #6,d2                     * Abstand der Buchstaben
texta1:
 tst.b (a0)
 beq.s textaend                 * Null ist Ende
 bsr erapen                     * Erst vorlschen
 move.b #10,gdp.w
 bsr setpen                     * Dann setzen
 move d1,d0
 move.b d0,gdp+9*cpu.w
 lsr #8,d0
 move.b d0,gdp+8*cpu.w          * Neue X-Position
 move.b (a0)+,d0
 bsr cmdput                     * Dann ausgeben
 add d2,d1                      * Neue Position feststellen / nicht mit getxy
bra.s texta1                    * Nchstes Zeichen
textaend:
 movem.l (a7)+,d0-d2/a0
rts

textprint:                      * Wie textaus aber mit $a = CRLF
 movem.l d0/d2/d3/a0,-(a7)      * Ohne Vorlschen
 bsr.s setprt                   * Mit Sonderzeichen
 move d0,d3
textpr1:
 move.b (a0)+,d0                * Null ist Endekennung
 beq.s textprend
 cmp.b #$a,d0                   * $a ist Linefeed
 bne.s textpr3
 move d3,d0                     * CR LF
 and #$f,d0
 bne.s textpr2
 moveq #16,d0                   * Null ist Vergrerung 16
textpr2:
 mulu #10,d0                    * Schrifthhe
 sub d0,d2
 bsr moveto                     * Wieder neu Positionieren
bra.s textpr1
textpr3:
 bsr cmdput                     * Mit Sonderzeichenausgabe
bra.s textpr1
textprend:
 movem.l (a7)+,d0/d2/d3/a0
rts

menueio:
 bsr clrall                     * Mit Bildschirmlschen
menueio0:                       * a0 = Ausgabetext
 moveq #$22,d0                  * Mentext ausgeben vo $33 auf $22 verringert
 moveq #30,d1
 move #190,d2
 bsr.s textprint                * Auch Linefeed erlaubt ohne Vorlschen, da clr
menueio1:
 moveq #$22,d0                  * Dann maximal ein Zeichen einlesen
 moveq #30,d1
 moveq #3,d2
 moveq #1,d3                    * Nur ein Zeichen lesen
 lea einbuf(a5),a0
 bsr.s textein
 bcc.s menueio2
 moveq #'Z',d5                  * ESC
menueio2:
 move.b d5,d0                   * Eingegebenes Zeichen nach d0
 bsr namecheck                  * In Grobuchstaben wandeln
bcs.s menueio1
rts

umrande:                        * d0=size d1=x d2=y d3=Anzahl Zeichen
 movem.l d1-d4,-(a7)
 move d0,d4
 lsr #4,d4
 and #$f,d4
 bne.s umrande1
 moveq #16,d4                   * Vergrerung 16
umrande1:
 mulu d4,d3                     * Anzahl Zeichen
 mulu #6,d3                     * Zeichenbreite
 addq #3,d3                     * d3=size x * anzahl * 6 + 3
 move d0,d4
 and #$f,d4
 bne.s umrande2
 moveq #16,d4                   * Vergrerung 16
umrande2:
 asl #4,d4                      * Zeichenhhe
 addq #8,d4                     * d5= size y * 8 * 2 + 8
 subq #2,d1                     * Anfang etwas versetzt, damit Umrandung etwas
 subq #2,d2                     * entfernt ist
 asl #1,d2
 bsr gr1p5                      * Rechteck leer
 movem.l (a7)+,d1-d4
bra moveto                      * Alte Position

readaus:                        * Text einlesen mit vorheriger Ausgabe eines
 movem.l d0/d1/d3/d6/d7/a2-a4,-(a7) * beliebigen Textes
bra.s txtein0

textein:                        * Routine zum Einlesen eines Textes
 movem.l d0/d1/d3/d6/d7/a2-a4,-(a7) * d3 = Anzahl der maximal mglichen Zeichen
 clr.b (a0)                     * Cursorsteuerung mit Ctrl-S, Ctrl-D, Ctrl-H
 subq #1,d3                     * Auerdem DEL, Ctrl-T, Ctrl-V, Ctrl-U, Ctrl-P
txtein0:                        * ESC = Ende wie RETURN aber mit Carry = 1
 move d3,d5                     * Sonst Carry = 0
 movea.l a0,a3                  * a3 = Anfangsadresse (Zeigt auf erstes Zeichen)
 movea.l a0,a2                  * a2 = Cursorposition (Zeigt auf Cursorzeichen)
txtein1:
 addq #1,d3
 tst.b (a2)+                    * Ende suchen
 bne.s txtein1
 subq.l #1,a2
 movea.l a2,a4
txtein2:
 move.b #' ',(a4)+              * Feld lschen
dbra d5,txtein2
 clr.b (a4)                     * a4 = Endadresse (Zeigt auf Null)
 bsr textaus                    * Text und Leerzeichen ausgeben (Vorlschen
 bsr umrande                    * Rand ausgeben
 clr.b curon(a5)                * Keinen Cursor zeigen
 move d1,d6                     * d6 = Anfangskoordinate
 move d0,d7
 lsr #4,d7
 and #$f,d7                     * X-Vergrerung
 bne.s txtein3
 moveq #16,d7                   * 0 ist Vergrerung 16
txtein3:
 mulu #6,d7                     * d7 = Abstand zwischen zwei Zeichen
txtein4:                        * Schleife fr Cursordarstellung
 move a2,d1
 sub a3,d1
 mulu d7,d1
 add d6,d1                      * Aktuelle Bildschirmposition des Cursors
 bsr setpen
 bsr movetoo                    * Positionieren
 move.b #10,gdp.w               * Weier Hintergrund
 bsr erapen
 bsr movetoo
 move.b (a2),d0
 bsr cmdput                     * Invers ausgeben
 bsr txtecsts
 bcc.s txtein5                  * OK, wenn Zeichen
 moveq #1,d4
 bsr txteaus                    * Zeichen normal ausgeben
 bsr txtecsts
 bcs.s txtein4                  * Schleife, wenn kein Zeichen
txtein5:
 bsr.s txtein6                  * Zeichen auswerten
bra.s txtein4                   * Schleife, falls nicht unten beendet

txtecsts:
 moveq #13-1,d5                 * Auf Zeichen warten
txtecst0:
 bsr csts
 bne carres                     * OK, Zeichen da
 bsr sync
 beq.s txtecst0                 * Syncronimpuls abwarten
dbra d5,txtecst0
bra carset                      * Kein Zeichen da

txtein6:
 bsr ci                         * Zeichen holen
 cmp.b #1,d0                    * Ctrl-A
 bne.s txtein7
 moveq #1,d4
 bsr txteaus
 movea.l a3,a2                  * Cursor nach ganz vorne
rts
txtein7:
 cmp.b #4,d0                    * Ctrl-D
 bne.s txtein8
 tst.b 1(a2)
 beq.s txtein7a                 * Cursor schon ganz hinten, dann nicht bewegen
 moveq #1,d4
 bsr txteaus                    * Aktuelles Zeichen ausgeben
 addq.l #1,a2                   * Cursor weiter
txtein7a:
rts
txtein8:
 cmp.b #6,d0                    * Ctrl-F
 bne.s txtein9
 moveq #1,d4
 bsr txteaus
 lea -1(a4),a0
txte8a:
 cmpa.l a2,a0                   * Nicht vor Cursor
 beq.s txte8b
 cmp.b #' ',-(a0)               * Endeleerzeichen ignorieren
 beq.s txte8a
 addq.l #1,a0                   * Auf Zeichen hinter Leerzeichen
txte8b:
 movea.l a0,a2                  * Cursor setzen
rts
txtein9:
 cmp.b #7,d0                    * Ctrl-G
 bne.s txtein10
txtein9a:
 movea.l a2,a0                  * Cursoradresse
txtein9b:
 move.b 1(a0),(a0)+             * Zeichen bertragen
 bne.s txtein9b                 * Bis Ende
 move.b #' ',-1(a0)             * Leerzeichen ganz hinten
 moveq #-1,d4
bra txteaus                     * Alle Zeichen ab Cursor neu ausgeben
txtein10:
 cmp.b #$7f,d0                  * DEL
 bne.s txtein11
 bsr.s txte12a                  * Ctrl-S
bra.s txtein9a                  * Dann lschen
txtein11:
 cmp.b #16,d0                   * Ctrl-P
 bne.s txtein12
 btst.b #6, keydil(a5)          * GDP-FPGA da?
 bne.s txten11b                 * ja, dann auch user Zeichensatz
 eori.b #1, optflag(a5)
 bra.s txten11a
txten11b:
 addq.b #1,optflag(a5)          * einen Zeichensatz weiter
 cmp.b #3,optflag(a5)           * schon bei 3?
 blt.s txten11a                 * nein, dann OK
 clr.b optflag(a5)              * sonst wieder amerikanisch
txten11a:
rts

txtein12:
 cmp.b #8,d0                    * Ctrl-H
 beq.s txte12a
 cmp.b #19,d0                   * Ctrl-S
 bne.s txtein13
txte12a:
 cmpa.l a3,a2
 beq.s txte12b                  * Cursor schon ganz vorne, dann nicht bewegen
 moveq #1,d4
 bsr txteaus                    * Ein Zeichen ausgeben
 subq.l #1,a2                   * Cursor zurck
txte12b:
rts
txtein13:
 cmp.b #20,d0                   * Ctrl-T
 bne.s txtein14
 movea.l a2,a0                  * Cursoradresse
txte13a:
 move.b #' ',(a0)+              * Alle Zeichen hinter Cursor lschen
 cmpa.l a0,a4
 bne.s txte13a                  * Bis hinten
 moveq #-1,d4
bra txteaus                     * Alle zeichen ab Cursor ausgeben
txtein14:
 cmp.b #21,d0                   * Ctrl-U
 bne.s txtein15
txte14a:
 movea.l a4,a0                  * Endadresse
txte14b:
 move.b -(a0),1(a0)             * Zeichen verschieben
 cmpa.l a0,a2
 bne.s txte14b                  * Bis Cursorposition
 clr.b (a4)                     * Ende wieder setzen
 move.b #' ',(a0)               * Zeichen eifgen
 moveq #-1,d4
bra txteaus                     * Alle Zeichen ab Cursor ausgeben
txtein15:
 cmp.b #22,d0                   * Ctrl-V
 bne.s txtein16
 eori.b #$01,insl(a5)           * Einfgen an/aus
rts
txtein16:
 cmp.b #$d,d0                   * <RETURN>
 beq.s *+8
 cmp.b #$1b,d0                  * <ESC>
 bne.s txtein17
 move.l d0,d5
 moveq #1,d4
 bsr txteaus                    * Zeichen an Cursorstelle ordentlich ausgeben
bra.s txteinfi
txtein17:
 cmp.b #' ',d0                  * Controlzeichen ?
 bmi.s txtein19                 * Ja, dann zurck zur Abfrage
 bsr getcode                    * Zeichensatz berprfen
 move.l d0,d5                   * Zeichen merken
 btst.b #0,insl(a5)
 beq.s txtein18                 * Kein Einfgemodus
 bsr.s txte14a                  * Erst einfgen
txtein18:
 move.b d5,(a2)                 * Zeichen ablegen
 moveq #1,d4
 bsr txteaus                    * Zeichen ausgeben
 addq.l #1,a2                   * Cursor weiter
 cmpa.l a2,a4
 beq.s txteinfi                 * Wenn ganz hinten, dann Ende
txtein19:
rts
txteinfi:
 addq.l #4,a7                   * Stack reinigen, da kein Rcksprung
 move.l (a7),d0                 * Gre holen
 move d6,d1
 bsr erapen
 bsr umrande                    * Umrandung lschen
txtefi:
 cmpa.l a2,a4
 beq.s txtefi0                  * Endeleerzeichen bis Cursorposition ignorieren
 cmp.b #' ',-(a4)
 beq.s txtefi
 addq.l #1,a4                   * Adressausgleich
txtefi0:
 clr.b (a4)                     * Endemarkierung genau hinter letztes Zeichen
 cmp.b #$d,d5
 beq.s txtefi1
 cmp.b #$1b,d5
 beq.s txtefi1
 move.b -1(a4),d5               * Wenn nicht mit <RETURN> oder <ESC> beendet,
txtefi1:                        * dann enthlt d5 letztes Zeichen
 movea.l a4,a0
 suba.l a3,a4
 move.l a4,d4                   * Anzahl der Zeichen im Buffer
 bsr setpen                     * Wieder auf Schreiben
 movem.l (a7)+,d0/d1/d3/d6/d7/a2-a4
 cmp.b #$1b,d5
 beq carset                     * Ende mit <ESC>, dann Carry =1
bra carres

txteaus:                        * Ausgabe fr textein d0/d1/d4/a0 zerstrt
 movea.l a2,a0                  * a2 = Aktuelle Adresse
 move a2,d1                     * a3 = Anfangsadresse Text
 sub a3,d1                      * d4 = Maximale Anzahl auszugebender Zeichen
 mulu d7,d1                     * d7 = Abstand zwischen zwei Zeichen
 add d6,d1                      * d6 = Anfangsposition X
 bra.s txteaus2                 * d2 = Y-Postion
txteaus1:
 bsr erapen                     * Vorlschen
 bsr movetoo                    * Positionieren
 move.b #10,gdp.w               * Lschzeichen
 bsr setpen                     * Setzen
 bsr movetoo                    * Positionieren
 bsr cmdput                     * Zeichen ausgeben
 add d7,d1                      * Neue Position
txteaus2:
 move.b (a0)+,d0                * Nchstes Zeichen
dbeq d4,txteaus1                * Wenn Null, oder d3 =-1, dann Ende
rts

printv8d:                       * 32 Bit dezimal ausgeben
 tst.l d0                       * a0 -> Ziel d0.l Wert
 bpl.s print8d                  * Ausgabe dezimal mit Vorzeichen
 neg.l d0                       * d0.l zerstrt
 move.b #'-',(a0)+
print8d:                        * Ausgabe ohne Vorzeichen
 movem.l d1/d2,-(a7)
 clr.b -(a7)                    * Ende-Zeichen
prt8d2:
 moveq #0,d1
 moveq #32-1,d2                 * 32 Bit
prt8d3:
 asl.l #1,d0
 roxl.l #1,d1
 cmp #10,d1                     * Bis 10 aufspeichern
 bcs.s prt8d4
 sub #10,d1
 addq #1,d0
prt8d4:
dbra d2,prt8d3
 add.b #'0',d1                  * Als ASCII-Zeichen abspeichern
 move.b d1,-(a7)
 tst.l d0
bne.s prt8d2                    * Bis alle Ziffern fertig
prt8d5:
 move.b (a7)+,(a0)+             * In (a0)+ ablegen, da verkehrt im Stack
bne.s prt8d5
 subq.l #1,a0                   * a0 zeigt auf Null
 movem.l (a7)+,d1/d2
rts

print4d:
 clr.b -(a7)                    * Ausgabe d0.w 4 Stellen dezimal
 swap d0                        * Ausgabe ohne Vorzeichen
 clr d0                         * a0 -> Ziel
 swap d0                        * d0 zerstrt
print4d1:
 divu #10,d0                    * Durch 10 teilen
 swap d0                        * Rest holen
 add.b #'0',d0                  * In ASCII-Zeichen wandeln
 move.b d0,-(a7)                * Abspeichern
 clr d0                         * REST lschen
 swap d0                        * Bis d0=Null
bne.s print4d1
print4d2:
 move.b (a7)+,(a0)+             * In (a0)+ ablegen, da verkehrt im Stack
bne.s print4d2
 subq.l #1,a0                   * a0 zeigt auf Null
rts

print16b:                       * 16 Stellen binr fr Trace
 move.l d1,-(a7)
 moveq #16-1,d1
bra.s prt8b0

print8b:
 move.l d1,-(a7)                * Ein Byte binr ausgeben
 moveq #8-1,d1                  * a0 -> Ziel
prt8b0:
 btst d1,d0                     * Bit 7, dann Bit 6, usw. abfragen
 seq (a0)                       * 0 oder -1
 add.b #'1',(a0)+               * In ASCII wandeln
dbra d1,prt8b0
prt8b2:
 clr.b (a0)                     * Endekennung
 move.l (a7)+,d1
rts                             * Ende

print8x:
 move.l d1,-(a7)                * 8 Stellen Hexadezimal ausgeben
 moveq #8-1,d1                  * a0 -> Ziel
bra.s print1x                   * d0 zerstrt
print6x:                        * 6 Stellen
 move.l d1,-(a7)
 moveq #6-1,d1
 rol.l #8,d0
bra.s print1x
print4x:                        * 4 Stellen
 move.l d1,-(a7)
 moveq #4-1,d1
 swap d0
bra.s print1x
print2x:                        * 2 Stellen
 move.l d1,-(a7)
 moveq #2-1,d1
 ror.l #8,d0
print1x:                        * d1 = Anzahl Stellen-1
 swap d1                        * d1 retten
 rol.l #4,d0
 move d0,d1
 and.w #$f,d1
 move.b prttab(pc,d1.w),(a0)+   * Aus der Tabelle Wert holen
 swap d1                        * d1 zurck
dbra d1,print1x
 clr.b (a0)                     * Endekennung
 move.l (a7)+,d1
rts

prttab:                         * Tabelle fr hexadezimale Ausgabe
 dc.b '0123456789ABCDEF'

uhrprint:
 clr.b (a0)                     * Endekennung, wenn keine Uhr vorhanden
 tst.b uhrausw(a5)
 beq carset                     * Carry = 1, da keine Uhr
 move.l a0,-(a7)
 lea einbuf(a5),a0
 bsr getuhr                     * Uhrzeit holen
 movea.l (a7)+,a0
uhrprt0:                        * Einsprung, wenn Uhrzeit schon gelesen
 movem.l d0-d3/a1/a2,-(a7)
 move.b einbuf+5(a5),d1
 and #7,d1                      * Nur 1 bis 7
 move.b uhrtab0(pc,d1),d1
 lea uhrtab0(pc,d1),a1          * Adresse des Tages
uhrprt1:
 move.b (a1)+,(a0)+
dbeq d0,uhrprt1                 * Anzahl Buchstaben bertragen oder bis Ende
 subq.l #1,a0
 lea uhrtab1(pc),a1
 lea einbuf(a5),a2              * Zeiger auf Uhrdaten
 moveq #'.',d3                  * Trennzeichen fr Datum
 moveq #2-1,d1
uhrprt2:
 move.b #' ',(a0)+              * Leeraum
 move.b #' ',(a0)+
 moveq #3-1,d2
uhrprt3:
 clr d0
 move.b (a1)+,d0                * Zeiger holen
 move.b 0(a2,d0),d0             * Wert holen
 bsr print2x                    * Umwandeln
 move.b d3,(a0)+                * Trennzeichen ablegen
dbra d2,uhrprt3
 clr.b -(a0)                    * Endekennung
 moveq #':',d3                  * Trennzeichen fr Uhrzeit
dbra d1,uhrprt2
 movem.l (a7)+,d0-d3/a1/a2
bra carres                      * OK, Uhrzeit geholt

uhrtab0:
 dc.b 8,8,15,24,33,44,52,60

 dc.b 'Montag',0
 dc.b 'Dienstag',0
 dc.b 'Mittwoch',0
 dc.b 'Donnerstag',0
 dc.b 'Freitag',0
 dc.b 'Samstag',0
 dc.b 'Sonntag',0

uhrtab1:                        * Zeiger auf Bytes zur Ordnung der Uhrdaten
 dc.b 2,3,4,0,1,6

 ds 0

                                                           